//////////////////////////////////////////////////////////////////////////////
//  Copyright 2014 by Autodesk, Inc.  All rights reserved.
//
// This computer source code and related instructions and comments 
// are the unpublished confidential and proprietary information of 
// Autodesk, Inc. and are protected under applicable copyright and 
// trade secret law.  They may not be disclosed to, copied or used 
// by any third party without the prior written consent of Autodesk, Inc.
//////////////////////////////////////////////////////////////////////////////

/*globals $,jQuery,document, window, navigator*/

/*!
* ntp.content - Dynamic updates of new tab page content
*/

// Namespace
var ntp = ntp || {};
ntp.content = ntp.content || {};

/**
 * Load string table as json data
 */
ntp.content.applyLocalizedStrings = function(localizedStrings) {
    // Verify string data
    if (localizedStrings !== null) {
        // Load localized strings and initialize text elements
        $('*[data-text-id]').each(function() {
            var $element = $(this);
            $element.html(localizedStrings[$element.data('text-id')]);
        });

        $('*[data-text-map]').each(function() {
            var $element = $(this);
            var textMap = $element.data('text-map');
            $.each(textMap, function(index, value) {
                $element.attr(index, localizedStrings[value]);
            });
        });
    }
}
/**
 * Gets or sets the map from file type to thumbnail image
 */
ntp.content.thumbnail = (function() {
    var thumbnails = {};
    var defaultThumbnail = 'images/default_thumb.png';

    // Gets or sets the settings object.
    return function(param, param1) {
        if ( typeof param === 'string') {
            if ( typeof param1 === 'string') {
                // Setting value
                thumbnails[param] = param1;
            } else {
                // Getting value
                var thumbnail = thumbnails[param];

                if ( typeof thumbnail === 'string') {
                    return thumbnail;
                } else {
                    return defaultThumbnail;
                }
            }

        } else {
            $.error('Invalid paramters.');
        }
    }
})();

/**
 * Updates of learn tab content
 */
ntp.content.learnTab = (function() {

    var hilightedContents = {};
    var hasFeaturedVideo = false;
    var hasGetStartedVideo = false;
    var hasResource = false;
    var hasTip = false;
    var notificationNum = 0;
    var $footerBadge = null;
    var hilight = (function () {
        return {
            createElement: function (linkurl, uploadTime) {
                return $('<span>').addClass('newcontent').addClass('hidden').data({
                    url: linkurl,
                    upload_time: new Date(uploadTime)
                });
            }
        }
    })();
    var loadVideoList = function ($list, videos) {
        $list.empty();

        $.each(videos, function (i, video) {
            var $preview = $('<div>').addClass('video_preview');
            $preview.append($('<img>').addClass('thumb').attr({
                src : video.thumb,
                alt : 'thumbnail'
            })).append($('<span>').addClass('overlay'));

            var $title = $('<div>').addClass('title').html(video.title)
            var $info = $('<div>').append($title, $('<div>').addClass('desc').html(video.description).append($('<div>').addClass('duration').html(video.duration)), $('<div>').css('clear', 'both'));

            var $item = $('<li>').append($preview, $info).data({
                url: video.video,
                title: video.title,
                upload_time: video.upload_time
            });
            $list.append($item);

            if (typeof video.video !== 'undefined' && typeof video.upload_time !== 'undefined') {
                var uploadTimeFromServer = new Date(video.upload_time);

                if (uploadTimeFromServer > ntp.video.releasetime) {
                    $preview.append(hilightedContents[video.video] = hilight.createElement(video.video, video.upload_time));
                }
            }

            $item.click(ntp.utils.makeCallbackWithArgs(ntp.video, 'showPlayer', $item));
        });
    }

    var urlIsHilightedContent = function (url) {
        if (typeof hilightedContents[url] !== 'undefined' && !hilightedContents[url].hasClass('hidden')) {
            return true;
        } else {
            return false;
        }
    }

    var updateSectionVideos = function (data) {
        hasFeaturedVideo = (typeof data.featuredVideoList !== 'undefined');
        hasGetStartedVideo = (typeof data.videoListSmall !== 'undefined');
        
        //Getting started videos
        if (typeof data.videoListSmall === 'object' && data.videoListSmall.video instanceof Array) {
            if (typeof data.videoListSmall.title === 'string') {
                $('#getting_started h1').text(data.videoListSmall.title);
            }

            loadVideoList($('#getting_started ol'), data.videoListSmall.video);
        } else {
            var $gettingStarted = $("#getting_started");
            $gettingStarted.next().remove();
            $gettingStarted.remove();
        }
        //feature videos
        if (typeof data.featuredVideoList === 'object' && data.featuredVideoList.video instanceof Array) {
            if (typeof data.featuredVideoList.title === 'string') {
                $('#feature_videos h1').text(data.featuredVideoList.title);
            }

            loadVideoList($('#feature_videos ol'), data.featuredVideoList.video);
        } else {
            var $featureVideos = $('#feature_videos');
            $featureVideos.remove();
        }
        //If the Getting Started and Feature Videos are not there remove section
        if ($('#feature_videos').length === 0 && $('#getting_started').length === 0) {
            var $sectionVidoes = $('#section_videos');
            $sectionVidoes.next().remove();
            $sectionVidoes.remove();
        }
        //update video column height.
        ntp.page.layout.updateVideoSectionHeight();
    }

    var updateLearnTipsSection = function (data) {
        if (data.learnTips) {
            hasTip = true;
            var $tipContainer = $('#tip_container');
            var $tipResources = $('#tip_resource_box');
            var $tipDiv = $('<div id="tipdiv" style="position:relative">');

            if (data.learnTips.title) {
                $('#section_resources h1.tip').text(data.learnTips.title);
            }

            if (data.learnTips.content) {
                $tipDiv.append($('<p style="margin-right:24px">').text(data.learnTips.content));

                if (typeof data.learnTips.caption !== 'undefined') {
                    $tipDiv.append($('<a href="fakeurl" tabindex="-1">').text(data.learnTips.caption).on("click", function (e) {

                        if (typeof data.learnTips.helpTopicId !== 'undefined' && data.learnTips.helpTopicId !== "")
                            ntp.acad.openUrlWithHelpBrowser(data.learnTips.helpTopicId);
                        else if (typeof data.learnTips.url !== 'undefined' && data.learnTips.url !== "")
                            ntp.acad.openUrlWithBrowser(data.learnTips.url);

                        e.preventDefault();
                    }));
                }
                $tipResources.append($tipDiv);

                $tipResources.data({
                    upload_time: data.learnTips.upload_time
                });

                //Append the hilight span if the tip is never visited
                if (typeof data.learnTips.content !== 'undefined' && typeof data.learnTips.upload_time !== 'undefined') {

                    var uploadTimeFromServer = new Date(data.learnTips.upload_time);
                    if (uploadTimeFromServer > ntp.video.releasetime) {
                        $tipContainer.append(hilightedContents['tip'] = hilight.createElement('tip', data.learnTips.upload_time));
                    }
                }
            }
        }
        else {
            var $tipSection = $('#Section_tip');
            if (typeof $tipSection != 'undefined' && $tipSection != null)
                $('#Section_tip').remove();
        }
    }

    var updateOnlineResource = function(data) {
        if (data.onlineResources) {
            hasResource = true;
            var $onlineResources = $('#online_resources_box');
            if (data.onlineResources.title) {
                $('#section_resources h1.resources').text(data.onlineResources.title);
            }
            if (data.onlineResources.description) {
                $onlineResources.append($('<p>').text(data.onlineResources.description));
            }
            if (data.onlineResources.links instanceof Array) {
                var $list = $('<ol>').addClass('flex');
                $onlineResources.append($list);

                $.each(data.onlineResources.links, function (i, link) {

                    var $listItem = $('<li>').addClass('button').append($('<img>').attr({
                        src: link.banner,
                        alt: link.caption
                    })).append($('<p>').text(link.caption));

                    //Append the hilight span if its a new link
                    if ((typeof link.url !== 'undefined' || typeof link.helpTopicId !== 'undefined') && typeof link.upload_time !== 'undefined') {
                        
                        var uploadTimeFromServer = new Date(link.upload_time);
                        if (uploadTimeFromServer > ntp.video.releasetime) {
                            {
                                if (typeof link.url !== 'undefined')
                                    $listItem.append(hilightedContents[link.url] = hilight.createElement(link.url, link.upload_time));
                                else
                                    $listItem.append(hilightedContents[link.helpTopicId] = hilight.createElement(link.helpTopicId, link.upload_time));
                            }
                        }
                    }

                    $list.append($listItem);

                    if (link.url) {
                        if (link.external === true) {
                            $listItem.click(function() {
                                ntp.utils.openExternalUrlWithBrowser(link.url);
                                var $lightBoxPanel = $('#lightbox_panel');
                                $lightBoxPanel.addClass('leave_autodesk');

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        } else {
                            $listItem.click(function() {
                                ntp.acad.openUrlWithBrowser(link.url);

                                if (urlIsHilightedContent(link.url) === true) {
                                    ntp.acad.updateLearnContentState(link.url, link.upload_time);
                                }
                            });
                        }
                    } else if (typeof link.helpTopicId === 'string' && link.helpTopicId !== "") {
                        $listItem.click(function (e) {
                            ntp.acad.openUrlWithHelpBrowser(link.helpTopicId);
                            e.preventDefault();
                            if (urlIsHilightedContent(link.helpTopicId) === true) {
                                ntp.acad.updateLearnContentState(link.helpTopicId, link.upload_time);
                            }
                        });
                    }
                });
            }

            ntp.page.layout.updateOnlineResourceHeight();
        } else {
            var $sectionResources = $('#section_resourceslinks');
            $sectionResources.remove();
        }
    }
    
    return {
        // ntp.content.learnTab
        urlIsHilightedContent: urlIsHilightedContent,

        hilightNewLearnConents: function (registryRecords) {
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url) && typeof hilightedContents[url] !== 'undefined') {
                    if (typeof registryRecords[url] === 'undefined' ||
                        hilightedContents[url].data('upload_time') > new Date(registryRecords[url])) {
                            hilightedContents[url].removeClass('hidden');
                            notificationNum++;
                        }
                }
            }

            //Update badge showing number.
            $footerBadge.html(notificationNum.toString());
            if (notificationNum > 0) {
                $footerBadge.removeClass('hidden');
            }
        },

        hasFeaturedVideos: function() {
            return hasFeaturedVideo;
        },
        
        hasGetStartedVideos: function() {
            return hasGetStartedVideo;
        },
        
        hasOnlineResource: function() {
            return hasResource;
        },
        
        hasTips: function() {
            return hasTip;
        },

        unhilightViewedLearnConents: function (registryRecords) {

            if (typeof registryRecords['RecentViewed'] !== 'undefined' &&
                urlIsHilightedContent(registryRecords['RecentViewed']) === true) {

                if (registryRecords['RecentViewed'] === 'tip' && ntp.page.tabs.isTipContentsVisited() === false) {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                } else if (registryRecords['RecentViewed'] !== 'tip') {
                    hilightedContents[registryRecords['RecentViewed']].addClass('hidden');
                    notificationNum--;
                }
            }

            if (typeof registryRecords['tip'] !== 'undefined' && urlIsHilightedContent('tip') === true) {
                hilightedContents['tip'].addClass('hidden');
                notificationNum--;
            }
            //Update badge showing number.
            if ($footerBadge !== null) {
                $footerBadge.html(notificationNum.toString());
                if (notificationNum === 0) {
                    $footerBadge.addClass('hidden');
                }
            }
        },

        unhilightRecentViewed: function (RegisteredInfo) {
            this.unhilightViewedLearnConents($.parseJSON(RegisteredInfo));
        },

        hilightRecentUpdates: function (RegisteredInfo) {
            this.hilightNewLearnConents($.parseJSON(RegisteredInfo));
        },

        load: function(data) {

            $footerBadge = $('#footer_learn_badge');

            //load A360 widget based on url.
            if (typeof data.url_connect_widget === 'string' && data.url_connect_widget !== "") {
                //Set url and try to load A360 widget
                ntp.widget.connect.setWidgetURL(data.url_connect_widget);
            }
            ntp.widget.connect.beginRefresh();

            if (typeof data.release_time === 'string') {
                ntp.video.releasetime = new Date(data.release_time);
            }
            if ( typeof data.videoWidth === 'number') {
                ntp.video.videoWidth = data.videoWidth;
            }
            if ( typeof data.videoHeight === 'number') {
                ntp.video.videoHeight = data.videoHeight;
            }

            if ( typeof data.videoListLarge === 'object' && data.videoListLarge.video instanceof Array) {
                if ( typeof data.videoListLarge.title === 'string') {
                    $('#section_whats_new h1').text(data.videoListLarge.title);
                }
                loadVideoList($('#section_whats_new ol'), data.videoListLarge.video);
            } else {
                var $sectionWhatsNew = $('#section_whats_new');
                $sectionWhatsNew.next().remove();
                $sectionWhatsNew.remove();
            }

            //update Section videos
            updateSectionVideos(data);

            //update learn tips section
            updateLearnTipsSection(data);

            //update online resource
            updateOnlineResource(data);

            //Hilight the Recently added learn contents.
            var RecentlyUpdatedUrls = [];
            for (var url in hilightedContents) {
                if (hilightedContents.hasOwnProperty(url))
                    RecentlyUpdatedUrls.push(url);
            }
            if (RecentlyUpdatedUrls.length > 0)
                ntp.acad.getLearnContentStateListAsJSON(RecentlyUpdatedUrls).done(ntp.utils.makeCallback(this, 'hilightRecentUpdates'));

        }
    }
})();

/**
 * Triggers update of content on events
 */
(function() {
    ntp.deferred.customization.done(function() {
        ntp.deferred.strings.done(function(data) {
            ntp.content.applyLocalizedStrings(data);
            ntp.deferred.localization.resolve();
        });
    });

    $.when(ntp.deferred.localization, ntp.deferred.customization).done(function() {
        
        $.when.apply(null, ntp.asyncLoadings).always(function() {
            ntp.widget.notifications.adjustContainerHeight();
            $('#preload_mask').remove();
        });

        // Load the content of learn tab
        ntp.deferred.learnTab.done(function(data) {

            ntp.widget.connect.setIsOnline(true);
            ntp.content.learnTab.load(data);

            // Move hidden learn tab content to target place.
            var $preloadLearn = $('#preload_learn');
            $('#tab_learn .placeholder').remove();
            $('#tab_learn .content').empty().append($preloadLearn.children());
            $preloadLearn.remove();

            $('#footer_nav').removeClass("hidden");
            $('#nav_arrow').removeClass("hidden");
            $('#left_side_nav').removeClass("hidden");
            ntp.page.footerNavs.update();
            ntp.page.layout.update();
        }).fail(function() {
            // Show offine help download notification box when load learn page failure.
            ntp.widget.notifications.beginGetOfflineHelpStatus();
            ntp.widget.connect.setIsOnline(false);
            ntp.widget.connect.beginRefresh();
        });
    });
})();

// SIG // Begin signature block
// SIG // MIIZNgYJKoZIhvcNAQcCoIIZJzCCGSMCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFMVq5/l8HkYf
// SIG // N6IphI3Hnr15Y/ajoIIUMDCCA+4wggNXoAMCAQICEH6T
// SIG // 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
// SIG // CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
// SIG // cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
// SIG // EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
// SIG // Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
// SIG // aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
// SIG // NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
// SIG // bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
// SIG // bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
// SIG // RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
// SIG // AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
// SIG // FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
// SIG // a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
// SIG // AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
// SIG // +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
// SIG // 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
// SIG // 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
// SIG // RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
// SIG // gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
// SIG // gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
// SIG // aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
// SIG // CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
// SIG // Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
// SIG // bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
// SIG // VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
// SIG // VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
// SIG // BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
// SIG // nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
// SIG // sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
// SIG // JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
// SIG // g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
// SIG // UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
// SIG // MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
// SIG // BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
// SIG // dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
// SIG // MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
// SIG // VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
// SIG // AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
// SIG // cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
// SIG // ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
// SIG // sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
// SIG // duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
// SIG // TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
// SIG // YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
// SIG // vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
// SIG // nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
// SIG // 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
// SIG // EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
// SIG // FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
// SIG // BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
// SIG // AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
// SIG // MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
// SIG // bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
// SIG // MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
// SIG // ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
// SIG // MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
// SIG // VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
// SIG // IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
// SIG // SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
// SIG // st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
// SIG // JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
// SIG // dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
// SIG // bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
// SIG // K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
// SIG // SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
// SIG // ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
// SIG // w7wc2AR1MIIFhTCCBG2gAwIBAgIQKcFbP6rNUmpOZ708
// SIG // Tn4/8jANBgkqhkiG9w0BAQUFADCBtDELMAkGA1UEBhMC
// SIG // VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
// SIG // VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTswOQYD
// SIG // VQQLEzJUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cu
// SIG // dmVyaXNpZ24uY29tL3JwYSAoYykxMDEuMCwGA1UEAxMl
// SIG // VmVyaVNpZ24gQ2xhc3MgMyBDb2RlIFNpZ25pbmcgMjAx
// SIG // MCBDQTAeFw0xMjA3MjUwMDAwMDBaFw0xNTA5MjAyMzU5
// SIG // NTlaMIHIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKQ2Fs
// SIG // aWZvcm5pYTETMBEGA1UEBxMKU2FuIFJhZmFlbDEWMBQG
// SIG // A1UEChQNQXV0b2Rlc2ssIEluYzE+MDwGA1UECxM1RGln
// SIG // aXRhbCBJRCBDbGFzcyAzIC0gTWljcm9zb2Z0IFNvZnR3
// SIG // YXJlIFZhbGlkYXRpb24gdjIxHzAdBgNVBAsUFkRlc2ln
// SIG // biBTb2x1dGlvbnMgR3JvdXAxFjAUBgNVBAMUDUF1dG9k
// SIG // ZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCoYmDrmd0Gq8ezSsDlfgaJFEFplNPNhWzM
// SIG // 2uFQaYAB/ggpQ11+N4B6ao+TqrNIWDIqt3JKhaU889nx
// SIG // l/7teWGwuOurstI2Z0bEDhXiXam/bicK2HVLyntliQ+6
// SIG // tT+nlgfN8tgB2NzM0BpE1YCnU2b6DwQw4V7BV+/F//83
// SIG // yGFOpePlumzXxNw9EKWkaq81slmmTxf7UxZgP9PGbLw8
// SIG // gLAPk4PTJI97+5BBqhkLb1YqSfWn3PNMfsNKhw/VwAN0
// SIG // dRKeM6H8SkOdz+osr+NyH86lsKQuics4fwK5uFSHQHsI
// SIG // t6Z0tqWvminRqceUi9ugRlGryh9X1ZqCqfL/ggdzYa3Z
// SIG // AgMBAAGjggF7MIIBdzAJBgNVHRMEAjAAMA4GA1UdDwEB
// SIG // /wQEAwIHgDBABgNVHR8EOTA3MDWgM6Axhi9odHRwOi8v
// SIG // Y3NjMy0yMDEwLWNybC52ZXJpc2lnbi5jb20vQ1NDMy0y
// SIG // MDEwLmNybDBEBgNVHSAEPTA7MDkGC2CGSAGG+EUBBxcD
// SIG // MCowKAYIKwYBBQUHAgEWHGh0dHBzOi8vd3d3LnZlcmlz
// SIG // aWduLmNvbS9ycGEwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
// SIG // cQYIKwYBBQUHAQEEZTBjMCQGCCsGAQUFBzABhhhodHRw
// SIG // Oi8vb2NzcC52ZXJpc2lnbi5jb20wOwYIKwYBBQUHMAKG
// SIG // L2h0dHA6Ly9jc2MzLTIwMTAtYWlhLnZlcmlzaWduLmNv
// SIG // bS9DU0MzLTIwMTAuY2VyMB8GA1UdIwQYMBaAFM+Zqep7
// SIG // JvRLyY6P1/AFJu/j0qedMBEGCWCGSAGG+EIBAQQEAwIE
// SIG // EDAWBgorBgEEAYI3AgEbBAgwBgEBAAEB/zANBgkqhkiG
// SIG // 9w0BAQUFAAOCAQEA2OkGvuiY7TyI6yVTQAYmTO+MpOFG
// SIG // C8MflHSbofJiuLxrS1KXbkzsAPFPPsU1ouftFhsXFtDQ
// SIG // 8rMTq/jwugTpbJUREV0buEkLl8AKRhYQTKBKg1I/puBv
// SIG // bkJocDE0pRwtBz3xSlXXEwyYPcbCOnrM3OZ5bKx1Qiii
// SIG // vixlcGWhO3ws904ssutPFf4mV5PDi3U2Yp1HgbBK/Um/
// SIG // FLr6YAYeZaA8KY1CfQEisF3UKTwm72d7S+fJf++SOGea
// SIG // K0kumehVcbavQJTOVebuZ9V+qU0nk1lMrqve9BnQK69B
// SIG // QqNZu77vCO0wm81cfynAxkOYKZG3idY47qPJOgXKkwmI
// SIG // 2+92ozCCBgowggTyoAMCAQICEFIA5aolVvwahu2WydRL
// SIG // M8cwDQYJKoZIhvcNAQEFBQAwgcoxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UE
// SIG // CxMxKGMpIDIwMDYgVmVyaVNpZ24sIEluYy4gLSBGb3Ig
// SIG // YXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVy
// SIG // aVNpZ24gQ2xhc3MgMyBQdWJsaWMgUHJpbWFyeSBDZXJ0
// SIG // aWZpY2F0aW9uIEF1dGhvcml0eSAtIEc1MB4XDTEwMDIw
// SIG // ODAwMDAwMFoXDTIwMDIwNzIzNTk1OVowgbQxCzAJBgNV
// SIG // BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEf
// SIG // MB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7
// SIG // MDkGA1UECxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8v
// SIG // d3d3LnZlcmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNV
// SIG // BAMTJVZlcmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5n
// SIG // IDIwMTAgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQD1I0tepdeKuzLp1Ff37+THJn6tGZj+qJ19
// SIG // lPY2axDXdYEwfwRof8srdR7NHQiM32mUpzejnHuA4Jnh
// SIG // 7jdNX847FO6G1ND1JzW8JQs4p4xjnRejCKWrsPvNamKC
// SIG // TNUh2hvZ8eOEO4oqT4VbkAFPyad2EH8nA3y+rn59wd35
// SIG // BbwbSJxp58CkPDxBAD7fluXF5JRx1lUBxwAmSkA8taEm
// SIG // qQynbYCOkCV7z78/HOsvlvrlh3fGtVayejtUMFMb32I0
// SIG // /x7R9FqTKIXlTBdOflv9pJOZf9/N76R17+8V9kfn+Bly
// SIG // 2C40Gqa0p0x+vbtPDD1X8TDWpjaO1oB21xkupc1+NC2J
// SIG // AgMBAAGjggH+MIIB+jASBgNVHRMBAf8ECDAGAQH/AgEA
// SIG // MHAGA1UdIARpMGcwZQYLYIZIAYb4RQEHFwMwVjAoBggr
// SIG // BgEFBQcCARYcaHR0cHM6Ly93d3cudmVyaXNpZ24uY29t
// SIG // L2NwczAqBggrBgEFBQcCAjAeGhxodHRwczovL3d3dy52
// SIG // ZXJpc2lnbi5jb20vcnBhMA4GA1UdDwEB/wQEAwIBBjBt
// SIG // BggrBgEFBQcBDARhMF+hXaBbMFkwVzBVFglpbWFnZS9n
// SIG // aWYwITAfMAcGBSsOAwIaBBSP5dMahqyNjmvDz4Bq1EgY
// SIG // LHsZLjAlFiNodHRwOi8vbG9nby52ZXJpc2lnbi5jb20v
// SIG // dnNsb2dvLmdpZjA0BgNVHR8ELTArMCmgJ6AlhiNodHRw
// SIG // Oi8vY3JsLnZlcmlzaWduLmNvbS9wY2EzLWc1LmNybDA0
// SIG // BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6
// SIG // Ly9vY3NwLnZlcmlzaWduLmNvbTAdBgNVHSUEFjAUBggr
// SIG // BgEFBQcDAgYIKwYBBQUHAwMwKAYDVR0RBCEwH6QdMBsx
// SIG // GTAXBgNVBAMTEFZlcmlTaWduTVBLSS0yLTgwHQYDVR0O
// SIG // BBYEFM+Zqep7JvRLyY6P1/AFJu/j0qedMB8GA1UdIwQY
// SIG // MBaAFH/TZafC3ey78DAJ80M5+gKvMzEzMA0GCSqGSIb3
// SIG // DQEBBQUAA4IBAQBWIuY0pMRhy0i5Aa1WqGQP2YyRxLvM
// SIG // DOWteqAif99HOEotbNF/cRp87HCpsfBP5A8MU/oVXv50
// SIG // mEkkhYEmHJEUR7BMY4y7oTTUxkXoDYUmcwPQqYxkbdxx
// SIG // kuZFBWAVWVE5/FgUa/7UpO15awgMQXLnNyIGCb4j6T9E
// SIG // mh7pYZ3MsZBc/D3SjaxCPWU21LQ9QCiPmxDPIybMSyDL
// SIG // kB9djEw0yjzY5TfWb6UgvTTrJtmuDefFmvehtCGRM2+G
// SIG // 6Fi7JXx0Dlj+dRtjP84xfJuPG5aexVN2hFucrZH6rO2T
// SIG // ul3IIVPCglNjrxINUIcRGz1UUpaKLJw9khoImgUux5Ol
// SIG // SJHTMYIEcjCCBG4CAQEwgckwgbQxCzAJBgNVBAYTAlVT
// SIG // MRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UE
// SIG // CxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazE7MDkGA1UE
// SIG // CxMyVGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3LnZl
// SIG // cmlzaWduLmNvbS9ycGEgKGMpMTAxLjAsBgNVBAMTJVZl
// SIG // cmlTaWduIENsYXNzIDMgQ29kZSBTaWduaW5nIDIwMTAg
// SIG // Q0ECECnBWz+qzVJqTme9PE5+P/IwCQYFKw4DAhoFAKBw
// SIG // MBAGCisGAQQBgjcCAQwxAjAAMBkGCSqGSIb3DQEJAzEM
// SIG // BgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgor
// SIG // BgEEAYI3AgEVMCMGCSqGSIb3DQEJBDEWBBQSatYgbhUO
// SIG // PGSxPhpOP++WBE69yzANBgkqhkiG9w0BAQEFAASCAQCb
// SIG // wbf+AFRgqZOULGSeZw6rkxbgqsJgQSfr1zi9m1jhr316
// SIG // lXkzkIAT0TIzZmai6t5wLldopTQWssMwiQ+R17yuQfud
// SIG // 0E14eEPM79MapBugdE2KJGaqhppXuBQaJCX/bWBeLHS3
// SIG // yUMafl/a3ezhkI+1QuyRBLEbC6u6DYa93FExANrAOs65
// SIG // 8IYV/tdXIcARSZ9mBbpYM+RPqEUxdvCQLAHZPCHtINwB
// SIG // NA+8SCpu+cpbx58wiU3IDycNKrYbWpvqtnhhvHCLsiMv
// SIG // WdOLR3lAPN+Lt6crlfSwq2xAck2arX7MuX8DE/gdUC7F
// SIG // nBcVxxWp+wd2pBMKZfrQNZlc8LrGI3w/oYICCzCCAgcG
// SIG // CSqGSIb3DQEJBjGCAfgwggH0AgEBMHIwXjELMAkGA1UE
// SIG // BhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBvcmF0
// SIG // aW9uMTAwLgYDVQQDEydTeW1hbnRlYyBUaW1lIFN0YW1w
// SIG // aW5nIFNlcnZpY2VzIENBIC0gRzICEA7P9DjI/r81bgTY
// SIG // apgbGlAwCQYFKw4DAhoFAKBdMBgGCSqGSIb3DQEJAzEL
// SIG // BgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTE0MDIw
// SIG // NzEwMDkwM1owIwYJKoZIhvcNAQkEMRYEFCgOegXDaOPM
// SIG // xpJBretWoyL+UfFzMA0GCSqGSIb3DQEBAQUABIIBAITr
// SIG // lIWMc4+mxvPqHpvRjBXpYR3tpu0bMe/TofDw2xcrdI6f
// SIG // Szka7pa2J+Vp5Xdb4+bZpAkPghWpuXFvDSPvv+p6RRnl
// SIG // QiX0Dc9rHKNNQg0tdeiDCy81Quv1BfSHOdVN1R1g4a7S
// SIG // 4SVx1GpInKM19jimJW26WTqPXUvVsMIe98V53YN4InlV
// SIG // ydh+W0mHPDfCc7zpgrvM5KWIdKUmS+5lVPgp8ZePR44T
// SIG // p2KKFi/747MBFeNFMJrECHSKD1PPZsp3FTjmQBtKdSYR
// SIG // B2RoJHC+FKDY3w9Bvx2y0iSTr0yucmotYeVY6C2tLiX5
// SIG // /B66IQN1OEw7KGN1X8VpuPcjlPGi6iQ=
// SIG // End signature block
